Texture g_Tex;
sampler2D s = sampler_state {
	Texture = <g_Tex>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
	AddressU = CLAMP;
	AddressV = CLAMP;
};

float4 Weights = {1.0, 1.0, 1.0, 1.0};

float4 fBrightness( float2 texCoords : TEXCOORD0 ) : COLOR
{
	float4 Color = clamp(tex2D(s, texCoords) * Weights, 0.0, 1.0);
	return Color;
}

technique Brightness
{
	pass p0
	{
		PixelShader = compile ps_2_0 fBrightness();
	}
}